
#!/bin/bash

# Array of configuration files


configs=(
"models/large_model_single_cell_50_denoise_50_pca/args.txt"
"models/large_model_single_cell_100_denoise_100_pca/args.txt"
"models/large_model_single_cell_200_denoise_200_pca/args.txt"
"models/large_model_citeseq_20_denoise_20_pca/args.txt"
"models/large_model_citeseq_100_denoise_100_pca/args.txt"
"models/large_model_citeseq_200_denoise_200_pca/args.txt"
"models/large_model_cortex_50_denoise_50_pca/args.txt"
"models/large_model_cortex_100_denoise_100_pca/args.txt"
)

# Loop through each configuration
for config in "${configs[@]}"; do
    echo "Training model with ${config} configuration..."
    python scripts/main.py @${config} --checkpoints_to_keep 10000

    echo "Completed training for ${config} configuration."
    echo "----------------------------------------"
done

echo "All models trained successfully!"