
#!/bin/bash

# Array of configuration files


configs=(
"models/small_model_cortex_50_denoised_50_pca/args.txt"
"models/small_model_cortex_100_denoised_100_pca/args.txt"
"models/small_model_cortex_200_denoised_200_pca/args.txt"
"models/small_model_cortex_raw_200_pca/args.txt"
)

# Loop through each configuration
for config in "${configs[@]}"; do
    echo "Training model with ${config} configuration..."
    python scripts/main.py @${config} --checkpoints_to_keep 1000

    echo "Completed training for ${config} configuration."
    echo "----------------------------------------"
done

echo "All models trained successfully!"