#!/bin/bash

# Array of configuration files
configs=(0.1 0.5 0.8 1.0 2.0 4.0)

# Loop through each configuration
for config in "${configs[@]}"; do
    PYTORCH_ENABLE_MPS_FALLBACK=1 python scripts/main.py \
        --model_dir models/large_model_single_cell_pca25/ \
        --mps \
        --dataset single_cell \
        --config_file data/single_cell/pca25.json \
        --visualize \
        --test_noise_level=0 \
        --gibbs_iterations 5 \
        --rho_scheduling_type linear \
        --rho_start ${config} \
        --rho_end 0.1 \
        --initial_x measurement \
        --result_dir results/pca_25_confidence_${config//./_} \
        --pca_components 15 \
        --save_data \
        --test_on one_type_each \
        --repeated_sampling_factor 10 \
        --repeated_sampling_method none \
        --visualize_with_train_context
    echo "----------------------------------------"
done

echo "All models evaluated successfully!"