import numpy as np
# import random
from copy import deepcopy
from localglobal.bo.localbo_utils import latin_hypercube, from_unit_cube, to_unit_cube, onehot2ordinal
from localglobal.bo.optimizer import TurboOptimizer


class DummyMethod:
    """Used to store """
    def __init__(self, dim):
        self.dim = dim
        self.X = np.zeros((0, self.dim))
        self.fX = np.zeros((0, 1))


class RandomSearcherMixed:

    def __init__(self, config, lb, ub,
                 cont_dims,
                 cat_dims, wrap_discrete=True):
        self.config = config.astype(int)
        self.true_dim = len(cont_dims) + len(cat_dims)
        # Number of one hot dimensions
        self.n_onehot = int(np.sum(config))
        # One-hot bounds
        self.lb = np.hstack((np.zeros(self.n_onehot), lb))
        self.ub = np.hstack((np.ones(self.n_onehot), ub))
        self.dim = len(self.lb)
        # True dim is simply the number of parameters (do not care about one-hot encoding etc).
        self.max_evals = np.iinfo(np.int32).max  # NOTE: Largest possible int
        self.batch_size = None
        self.history = []
        self.wrap_discrete = wrap_discrete
        self.cat_dims = self.get_dim_info(config)

        # Number of one hot dimensions
        # One-hot bounds
        self.turbo = DummyMethod(self.true_dim)

    def get_dim_info(self, n_categories):
        dim_info = []
        offset = 0
        for i, cat in enumerate(n_categories):
            dim_info.append(list(range(offset, offset + cat)))
            offset += cat
        return dim_info

    def warp_discrete(self, X, ):
        X_ = np.copy(X)
        # Process the integer dimensions
        if self.cat_dims is not None:
            for categorical_groups in self.cat_dims:
                max_col = np.argmax(X[:, categorical_groups], axis=1)
                X_[:, categorical_groups] = 0
                for idx, g in enumerate(max_col):
                    X_[idx, categorical_groups[g]] = 1
        return X_

    def observe(self, X, y):
        assert len(X) == len(y)
        XX = X
        yy = np.array(y)[:, None]
        self.turbo.X = np.vstack((self.turbo.X, deepcopy(XX)))
        self.turbo.fX = np.vstack((self.turbo.fX, deepcopy(yy.reshape(-1, 1))))

    def suggest(self, n_suggestions=1):
        if self.batch_size is None:
            self.batch_size = n_suggestions
        X = latin_hypercube(self.batch_size, self.dim)
        X = from_unit_cube(X, self.lb, self.ub)
        X_cat, X_cont = X[:, :self.n_onehot], X[:, self.n_onehot:]
        if self.wrap_discrete:
            X_cat = self.warp_discrete(X_cat, )
        X_cat = onehot2ordinal(X_cat, self.cat_dims)
        X = np.hstack((X_cat, X_cont))
        return X

    def restart(self, **kwargs):
        pass
