# Runs the standard bo and turbo on the adversarial attack problem
import sys
sys.path.append('..')
sys.path.append('../..')
from localglobal.baselines.TuRBO.turbo import Turbo1, TurboM
from localglobal.baselines.vanilla_bo import BO
from localglobal.test_funcs import *
from localglobal.mixed_test_func import *
from localglobal.baselines.modifiedobjfunc import ModifiedObjectiveFunc
import logging
import argparse
import os
import pickle
import pandas as pd
import time, datetime
from localglobal.test_funcs.random_seed_config import *


# Set up the objective function
parser = argparse.ArgumentParser('Run Experiments for TurBO baseline')
parser.add_argument('--model_path', default=f'./mixed_test_func/AdvAttack/tf_models/', help='the save path of the victim model. This is a required argument.')
parser.add_argument('-o', '--optimizer', type=str, default='bo')
parser.add_argument('-n', '--n_trust_regions', type=int, default=1)
parser.add_argument('--starting_offset', type=int, default=0, help='Starting index of the image sequence.')
parser.add_argument('--max_iters', type=int, default=250, help='Maximum number of BO iterations.')
parser.add_argument('--batch_size', type=int, default=1, help='batch size for BO.')
parser.add_argument('--n_images', type=int, default=50)
parser.add_argument('--n_init', type=int, default=20)
parser.add_argument('--save_path', type=str, default='output/baselines/turbo/')
parser.add_argument('--ard', action='store_true')
parser.add_argument('-d', '--debug', action='store_true', help='Whether to turn on debugging mode (a lot of output will'
                                                               'be generated).')
parser.add_argument('--seed', type=int, default=None, help='**initial** seed setting')
parser.add_argument('--data_dir', default='./data/')
parser.add_argument('--normalize', action='store_true')
parser.add_argument('--infer_noise_var', action='store_true')

args = parser.parse_args()
options = vars(args)
print(options)


# Time string will be used as the directory name
time_string = datetime.datetime.now()
time_string = time_string.strftime('%Y%m%d_%H%M%S')

if args.debug:
    logging.basicConfig(level=logging.INFO)

# Create the relevant folders, and save the arguments to reproduce the experiment, etc.
save_path = os.path.join(args.save_path, 'AdvAttack', time_string)
if not os.path.exists(save_path):
    os.makedirs(save_path)
option_file = open(save_path + "/command.txt", "w+")
option_file.write(str(options))
option_file.close()

# Each trial is a sample
for t in range(args.n_images):
    print('----- Starting image number %d / %d -----' % ((t + 1), args.n_images))
    # Create a trial-specific path
    save_path_trial = os.path.join(save_path, 'image-%d' % (t + args.starting_offset))
    if not os.path.exists(save_path_trial):
        os.mkdir(save_path_trial)

    for i in range(9):
        kwargs = {}

        f = AdversarialAttack(args.model_path,
                              save_dir=save_path_trial,
                              target_label=i,
                              img_offset=t + args.starting_offset
                              )

        f = ModifiedObjectiveFunc(f)
        n_categories = f.n_vertices
        problem_type = f.problem_type

        res = pd.DataFrame(np.nan, index=np.arange(int(args.max_iters * args.batch_size)),
                           columns=['Index', 'LastValue', 'BestValue', 'Time'])

        if args.optimizer == 'turbo':
            if args.n_trust_regions == 1:
                bo = Turbo1(
                    f=f,
                    lb=f.lb,
                    ub=f.ub,
                    n_init=args.n_init,
                    max_evals=args.max_iters,
                    use_ard=args.ard,
                    verbose=True,
                    **kwargs)
            else:
                bo = TurboM(
                    f=f,
                    lb=f.lb,
                    ub=f.ub,
                    n_init=args.n_init,
                    max_evals=args.max_iters,
                    verbose=True,
                    use_ard=args.ard, **kwargs
                )
        elif args.optimizer == 'bo':
            bo = BO(
                f=f,
                lb=f.lb,
                ub=f.ub,
                n_init=args.n_init,
                max_evals=args.max_iters,
                use_ard=args.ard,
                verbose=True,
                **kwargs
            )
        else:
            raise NotImplementedError(args.optimizer + ' is not implemented as a valid optimizer choice!')
        bo.optimize(target_fX=0.)
        fX = bo.fX
        res.iloc[:fX.shape[0], 1] = fX.flatten()
        for i_ in range(fX.shape[0]):
            res.iloc[i_, 2] = np.min(fX[:i_+1])
        if save_path is not None:
            pickle.dump(res, open(os.path.join(save_path_trial, 'target_class-%d.pickle' % i), 'wb'))



