import sys
sys.path.append('../')
sys.path.append('../../')
from localglobal.baselines.TuRBO.turbo import Turbo1
import numpy as np
import os
import pickle
from tqdm import tqdm

save_dir = 'output/comp_restarts/'
if not os.path.exists(save_dir):
    os.makedirs(save_dir)


class Levy:
    def __init__(self, dim=50):
        self.dim = dim
        self.lb = -5 * np.ones(dim)
        self.ub = 10 * np.ones(dim)

    def __call__(self, x):
        assert len(x) == self.dim
        assert x.ndim == 1
        assert np.all(x <= self.ub) and np.all(x >= self.lb)
        w = 1 + (x - 1.0) / 4.0
        val = np.sin(np.pi * w[0]) ** 2 + \
              np.sum((w[1:self.dim - 1] - 1) ** 2 * (1 + 10 * np.sin(np.pi * w[1:self.dim - 1] + 1) ** 2)) + \
              (w[self.dim - 1] - 1) ** 2 * (1 + np.sin(2 * np.pi * w[self.dim - 1]) ** 2)
        return val


f = Levy(20)


## Test TuRBO with random restarts
for i in range(10):
    print(f'{i}/10')
    turbo1 = Turbo1(
        f=f,  # Handle to objective function
        lb=f.lb,  # Numpy array specifying lower bounds
        ub=f.ub,  # Numpy array specifying upper bounds
        n_init=20,  # Number of initial bounds from an Latin hypercube design
        max_evals=4000,  # Maximum number of evaluations
        batch_size=10,  # How large batch size TuRBO uses
        verbose=False,  # Print information from each batch
        use_ard=True,  # Set to true if you want to use ARD for the GP kernel
        max_cholesky_size=2000,  # When we switch from Cholesky to Lanczos
        n_training_steps=50,  # Number of steps of ADAM to learn the hypers
        min_cuda=1024,  # Run on the CPU for small datasets
        device="cpu",  # "cpu" or "cuda"
        dtype="float64",  # float64 or float32
        guided_restart=False,
        failtol=3,
        length_min=0.5**3
    )
    turbo1.optimize()

    X = turbo1.X  # Evaluated points
    fX = turbo1.fX  # Observed values
    save_res = {
        'X': X,
        'y': fX
    }
    pickle.dump(save_res, open(save_dir + f'random_restarts_trial_{i}.pickle', 'wb'))
    del save_res
    del X, fX
    del turbo1

## Test TuRBO with random restarts
for i in range(10):
    print(f'{i}/10')
    turbo1 = Turbo1(
        f=f,  # Handle to objective function
        lb=f.lb,  # Numpy array specifying lower bounds
        ub=f.ub,  # Numpy array specifying upper bounds
        n_init=20,  # Number of initial bounds from an Latin hypercube design
        max_evals=4000,  # Maximum number of evaluations
        batch_size=10,  # How large batch size TuRBO uses
        verbose=False,  # Print information from each batch
        use_ard=True,  # Set to true if you want to use ARD for the GP kernel
        max_cholesky_size=2000,  # When we switch from Cholesky to Lanczos
        n_training_steps=50,  # Number of steps of ADAM to learn the hypers
        min_cuda=1024,  # Run on the CPU for small datasets
        device="cpu",  # "cpu" or "cuda"
        dtype="float64",  # float64 or float32
        guided_restart=True,
        failtol=3,
        length_min=0.5 ** 3
    )
    turbo1.optimize()

    X = turbo1.X  # Evaluated points
    fX = turbo1.fX  # Observed values
    save_res = {
        'X': X,
        'y': fX
    }
    print(f'{i}/20')
    pickle.dump(save_res, open(save_dir + f'guided_restarts_trial_{i}.pickle', 'wb'))
    del save_res
    del X, fX
    del turbo1