import argparse
import datetime
import multiprocessing
import subprocess
import yaml
import os
import gym
import d4rl


def run_experiment(spec):
    subprocess.run(spec, check=True)


def run_all_experiments(specs):
    pool = multiprocessing.Pool()
    pool.map(run_experiment, specs)


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--yaml_file', type=str,
                        default='./args_yml/bo_test_rig_hoppermed.yml')
    parser.add_argument('--shift', type=int, default=73)
    parser.add_argument('--num_experiments', type=int, default=1)

    args = parser.parse_args()
    params = vars(args)

    # Extract out the environment from the yaml file so that we can preload the data.
    if params['yaml_file']:
        with open(args.yaml_file, 'r') as f:
            yaml_config = yaml.load(f, Loader=yaml.FullLoader)
            env_name = yaml_config['args']['env_name']
            if env_name != 'AntMOPOEnv':
                # Don't treat ant as the other D4RL datasets.
                e = gym.make(env_name)
                dataset = d4rl.qlearning_dataset(e)

    experiment_id = datetime.datetime.now().strftime('%Y_%m_%d_%H-%M-%S')

    lower = params['shift']
    upper = lower + params['num_experiments']

    main_experiment = ["python", "train.py", "--yaml_file", params['yaml_file'], "--uuid", experiment_id, "--seed"]

    all_experiments = [main_experiment + [str(i)] for i in range(lower, upper)]

    run_all_experiments(all_experiments)
