from typing import Counter, Callable

import pandas as pd
import attrs

from sandbagging.setting_types import Pbs


@attrs.frozen
class PbsSplits:
    val_split: Pbs
    train_baseline_split: Pbs
    train_lock_split: Pbs
    train_elicit_split: Pbs
    combined_data: Pbs = attrs.Factory(lambda self: self.all_combined(), takes_self=True)

    def __attrs_post_init__(self):
        p_id = [(p, id) for p, id in zip(self.combined_data.problem, self.combined_data.id)]
        assert len(set(p_id)) == len(self.combined_data), [x for x, v in Counter(p_id).items() if v > 1]

    @classmethod
    def from_dfs(
        cls,
        val_split: pd.DataFrame,
        train_baseline_split: pd.DataFrame,
        train_lock_split: pd.DataFrame,
        train_elicit_split: pd.DataFrame,
    ):
        return cls(
            val_split=Pbs.from_df(val_split),
            train_baseline_split=Pbs.from_df(train_baseline_split),
            train_lock_split=Pbs.from_df(train_lock_split),
            train_elicit_split=Pbs.from_df(train_elicit_split),
        )

    def all_combined(self):
        return pd.concat(
            [
                self.val_split,
                self.train_baseline_split,
                self.train_lock_split,
                self.train_elicit_split,
            ]
        )


@attrs.frozen
class SettingData:
    get_splits: Callable[[int], PbsSplits]


default_get_splits_seed = 238950
