from typing import Optional

import regex

from sandbagging.math_eval_utils import math_equal


def is_correct(pred, ans, prec=1e-3, timeout: Optional[float] = 2.0):
    if isinstance(pred, list) and isinstance(ans, list):
        # is this even the right logic here???
        pred_matched = set()
        ans_matched = set()
        for i in range(len(pred)):
            for j in range(len(ans)):
                if is_correct(pred=pred[i], ans=ans[j], prec=prec, timeout=timeout):
                    pred_matched.add(i)
                    ans_matched.add(j)
        return len(pred_matched) == len(pred) and len(ans_matched) == len(ans)
    elif isinstance(pred, str) and isinstance(ans, str):
        if "\\cup" in pred and "\\cup" in ans:
            return is_correct(pred=pred.split("\\cup"), ans=ans.split("\\cup"), prec=prec, timeout=timeout)
        else:
            label = False
            try:
                label = abs(float(regex.sub(r",", "", str(pred))) - float(regex.sub(r",", "", str(ans)))) < prec
            except:
                pass
            label = label or (ans and pred == ans) or math_equal(pred, ans, timeout=timeout)
            return label
    else:
        print(f"{pred=} {ans=}", flush=True)
        raise NotImplementedError()


def eval_math(pred, ans, prec=1e-3, timeout: Optional[float] = 2.0):
    if isinstance(pred, list) and isinstance(ans, list):
        # for some questions in MATH, `reference` repeats answers
        _ans = []
        for a in ans:
            if a not in _ans:
                _ans.append(a)
        ans = _ans
        # some predictions for MATH questions also repeats answers
        _pred = []
        for a in pred:
            if a not in _pred:
                _pred.append(a)
        # some predictions mistakenly box non-answer strings
        pred = _pred[-len(ans) :]

    return is_correct(pred, ans, prec=prec, timeout=timeout)
