# %%
import math

from sandbagging.utils.basic_utils import get_yes_no, model_api, single_tokenize
from sandbagging.dataset_wrapping import cache_dir, global_constant_probs


def get_yes_no_diff_logprobs(logprobs: dict[str, float]) -> float:
    eps = 1e-5
    prob_sums = {False: eps, True: eps}

    for k, v in logprobs.items():
        o = get_yes_no(k)
        if o is None:
            continue
        prob_sums[o] += math.exp(v)

    # print(prob_sums)

    assert prob_sums[False] != eps or prob_sums[True] != eps, ("key error in probs", logprobs)

    return math.log(prob_sums[True]) - math.log(prob_sums[False])


async def run_yes_no_log_probs(prompt):
    yes_no_tokens = [" No", "No", " no", "no", " Yes", "Yes", " yes", "yes"]
    logit_bias = {single_tokenize(token): 100 for token in yes_no_tokens}
    out = await model_api.call_cached(
        "gpt-3.5-turbo-instruct",
        prompt,
        logprobs=5,
        logit_bias=logit_bias,
        max_tokens=1,
    )
    logprobs = out[0].logprobs[0]
    return get_yes_no_diff_logprobs(logprobs)


# %%
import json
import random

from sandbagging.utils.loaded_problem import LoadedProblem

solutions = [json.loads(line) for line in open(f"{cache_dir}/solutions/smart_T0_n1.jsonl")]
random_solutions = random.Random(0).sample(solutions, 10)
for d in random_solutions:
    pb: LoadedProblem = global_constant_probs[d["pb_idx"]]
    solution = d["w_solution"]
    print(d["pb_idx"])
    print(pb.description)
    print(solution)
    print("=" * 80)
# %%

# kinds of critiques
# - too slow because (size)
# - does not handle cases like (case)
# - off by one error there because the edge should be (edge)
# - swapped sth (e.g. it should be a>b not a<b because of (reason))
# - wrong algorithm because (example where it breaks)
# - wrong use of the language, should be used like (example)
# - wrong use of the library, should be used like (example)
# - wrong input parsing, this code expects (this format) while the instruction says (this format)
# - wrong output formatting, this code outputs (this format) while the instruction says (this format)
#


# 1952
# forgot to pad with 0
# used minutes = minutes * 60 + hour instead of minutes = minutes + hour * 60
# used hour = minutes % 60 and minutes = minutes / 60 instead of the opposite
# did not parse the input correctly (forgot to cin the seperator)

# 1466
# did not deal with the case where s > t
# took the max instead of the min of the clockwise and counter clockwise distances
# only measured the clockwise distance
# off-by-one error in the for loop

# 1242
# too slow (runs in O(kn) and kn is on the order of 10^9 * 10^5 = 10^14)
# modifed the array directly instead of creating a copy
# did not handle the edge cases (chip 1 and n)
# wrong new color, it should be white when whiteCount > 1 not when whiteCount < 1

# 1658
# did not handle the case where all ratings are already x
# did not handle the case where at least on account has already rating x
# did not handle the case where all accounts can get to rating x in one contest
# only handles one test case, should cin t and then expect t test cases

# 1990
# used the wrong greedy approach, should have used dynamic programming
# initialized the dp array with 0s instead of -1s
# forgot the base case of the dp (dp[0][0] = 0)
# in the inner loop of the dp, started from 0 (did not use k)

# 2094
# started the operation count at 1 instead of 0
# used S.length instead of S.length()
# increased the operation count when characters were the same instead of different
# used the levenstein distance instead of the described
# %%
