# %%
import re
from pathlib import Path
from shutil import rmtree

ALL_RESULTS = False
ALL_WEIGHTS = True
ONLY_PRINT = False
DELETE_EMPTY = True

only_if = lambda folder: True
# only_if = lambda folder: re.match(r"^poor_man_pythia_sub16_it\d+_best_seed101$", folder)
# only_if = lambda folder: re.match(r"^poor_man_pythia.*?_sub16_it39", folder)
# only_if = lambda folder: folder.endswith("_f")
# only_if = lambda folder: re.match(r"^elicit_pythia_samp\d+_mm", folder)
# only_if = lambda folder: True
# only_if = lambda folder: folder not in ["basic_pythia_lock", "basic_pythia160m_lock", "basic_pythia7b_lock"]
# only_if = lambda folder: "basic_pythia_lock_but_" in folder
# only_if = lambda folder: "_pt" in folder
# folder = f"sandbagging/sandbagging_cache/Deepseek-7B"
# folder = f"sandbagging/sandbagging_cache/Deepseek-7B"
folders = [f"sandbagging/sandbagging_cache_c_mar13/Deepseek-7B_crit"]
# folders = [
#     "sandbagging/sandbagging_cache_feb3/Pythia-7B",
#     "sandbagging/sandbagging_cache_feb3/Pythia-1B",
#     "sandbagging/sandbagging_cache_feb3/Pythia-160M",
#     "sandbagging/sandbagging_cache_feb3/Pythia-7B_crit",
#     "sandbagging/sandbagging_cache_feb3/Pythia-1B_crit",
#     "sandbagging/sandbagging_cache_feb3/Pythia-160M_crit",
# ]

if ALL_RESULTS:
    assert ALL_WEIGHTS, "ALL_RESULTS requires ALL_WEIGHTS"

if (ALL_WEIGHTS or ALL_RESULTS) and not ONLY_PRINT:
    print("Warning: deleting all epochs in", folders)
    if ALL_RESULTS:
        print("also deleting all RESULTS")
    # sleep(5)

if ONLY_PRINT:
    print("Only printing, not deleting")

for folder in folders:
    if not Path(folder).exists():
        print(f"Folder {folder} does not exist")
        continue

    for model_dir in Path(folder).iterdir():
        tmp_folder = model_dir / "tmp"
        if not ONLY_PRINT and tmp_folder.exists():
            rmtree(tmp_folder)
            print(f"Deleted {tmp_folder}")

        if not only_if(model_dir.name):
            continue

        if ALL_RESULTS:
            print(f"Deleting {model_dir}")
            if not ONLY_PRINT:
                rmtree(model_dir)
            continue

        weight_folders = [f for f in model_dir.iterdir() if f.is_dir() and f.name.startswith("weights_")]
        epochs = [int(f.name.split("_")[-1]) for f in weight_folders]
        if len(epochs) == 0:
            continue
        last_epoch = max(epochs)

        for weight_folder in weight_folders:
            is_empty = len(list(weight_folder.iterdir())) == 0
            if is_empty and not DELETE_EMPTY:
                continue

            epoch = int(weight_folder.name.split("_")[-1])
            if epoch < last_epoch or ALL_WEIGHTS:
                print(f"Deleting {weight_folder}")
                if not ONLY_PRINT:
                    rmtree(weight_folder)
