examples = [
    {
        "pb_idx": 1466,
        "correct_code": """
#include <iostream>
#include <vector>
#include <algorithm>

int main() {
    int n;
    std::cin >> n;
    std::vector<int> distances(n);
    for (int i = 0; i < n; ++i) {
        std::cin >> distances[i];
    }

    int s, t;
    std::cin >> s >> t;

    // Make sure s is less than t for simplicity
    if (s > t) std::swap(s, t);

    // Calculate the distance by going clockwise
    int clockwise_distance = 0;
    for (int i = s - 1; i < t - 1; ++i) {
        clockwise_distance += distances[i];
    }

    // Calculate the distance by going counter-clockwise
    int counter_clockwise_distance = 0;
    for (int i = t - 1; i != s - 1; i = (i + 1) % n) {
        counter_clockwise_distance += distances[i];
    }

    // Output the minimum of the two distances
    std::cout << std::min(clockwise_distance, counter_clockwise_distance) << std::endl;

    return 0;
}""",
        "incorrect_code": """
#include <iostream>
#include <vector>
#include <algorithm>

int main() {
    int n;
    std::cin >> n;
    std::vector<int> distances(n);
    for (int i = 0; i < n; ++i) {
        std::cin >> distances[i];
    }

    int s, t;
    std::cin >> s >> t;

    // Make sure s is less than t for simplicity
    if (s > t) std::swap(s, t);

    // Calculate the distance by going clockwise
    int clockwise_distance = 0;
    for (int i = s - 1; i < t - 1; ++i) {
        clockwise_distance += distances[i];
    }

    // Calculate the distance by going counter-clockwise
    int counter_clockwise_distance = 0;
    for (int i = t - 1; i != s - 1; ++i) {
        counter_clockwise_distance += distances[i];
    }

    // Output the minimum of the two distances
    std::cout << std::min(clockwise_distance, counter_clockwise_distance) << std::endl;

    return 0;
}""",
        "critique": "In the counterclockwise loop, i goes up to n and then should wrap, therefore it should be i = (i + 1) % n.",
    },
    {
        "pb_idx": 1466,
        "correct_code": """
#include <iostream>
#include <vector>
#include <algorithm>

int main() {
    int n;
    std::cin >> n;
    std::vector<int> distances(n);
    for (int i = 0; i < n; ++i) {
        std::cin >> distances[i];
    }

    int s, t;
    std::cin >> s >> t;

    // Make sure s is less than t for simplicity
    if (s > t) std::swap(s, t);

    // Calculate the distance by going clockwise
    int clockwise_distance = 0;
    for (int i = s - 1; i < t - 1; ++i) {
        clockwise_distance += distances[i];
    }

    // Calculate the distance by going counter-clockwise
    int counter_clockwise_distance = 0;
    for (int i = t - 1; i != s - 1; i = (i + 1) % n) {
        counter_clockwise_distance += distances[i];
    }

    // Output the minimum of the two distances
    std::cout << std::min(clockwise_distance, counter_clockwise_distance) << std::endl;

    return 0;
}""",
        "incorrect_code": """
#include <iostream>
#include <vector>
#include <algorithm>

int main() {
    int n;
    std::cin >> n;
    std::vector<int> distances(n);
    for (int i = 0; i < n; ++i) {
        std::cin >> distances[i];
    }

    int s, t;
    std::cin >> s >> t;

    // Make sure s is less than t for simplicity
    if (s > t) std::swap(s, t);

    // Calculate the distance
    int distance = 0;
    for (int i = s - 1; i < t - 1; ++i) {
        distance += distances[i];
    }

    // Output the distance
    std::cout << distance << std::endl;

    return 0;
}""",
        "critique": "The smallest distance could also be in the other direction (going through 1 → n), therefore it should compute the distances in both direction and take the minimum of them.",
    },
    {
        "pb_idx": 1466,
        "correct_code": """
#include <iostream>
#include <vector>
#include <algorithm>

int main() {
    int n;
    std::cin >> n;
    std::vector<int> distances(n);
    for (int i = 0; i < n; ++i) {
        std::cin >> distances[i];
    }

    int s, t;
    std::cin >> s >> t;

    // Make sure s is less than t for simplicity
    if (s > t) std::swap(s, t);

    // Calculate the distance by going clockwise
    int clockwise_distance = 0;
    for (int i = s - 1; i < t - 1; ++i) {
        clockwise_distance += distances[i];
    }

    // Calculate the distance by going counter-clockwise
    int counter_clockwise_distance = 0;
    for (int i = t - 1; i != s - 1; i = (i + 1) % n) {
        counter_clockwise_distance += distances[i];
    }

    // Output the minimum of the two distances
    std::cout << std::min(clockwise_distance, counter_clockwise_distance) << std::endl;

    return 0;
}""",
        "incorrect_code": """
#include <iostream>
#include <vector>
#include <algorithm>

int main() {
    int n;
    std::cin >> n;
    std::vector<int> distances(n);
    for (int i = 0; i < n; ++i) {
        std::cin >> distances[i];
    }

    int s, t;
    std::cin >> s >> t;

    // Make sure s is less than t for simplicity
    if (s > t) std::swap(s, t);

    // Calculate the distance by going clockwise
    int clockwise_distance = 0;
    for (int i = s; i < t; ++i) {
        clockwise_distance += distances[i];
    }

    // Calculate the distance by going counter-clockwise
    int counter_clockwise_distance = 0;
    for (int i = t; i != s; i = (i + 1) % n) {
        counter_clockwise_distance += distances[i];
    }

    // Output the minimum of the two distances
    std::cout << std::min(clockwise_distance, counter_clockwise_distance) << std::endl;

    return 0;
}""",
        "critique": "t and s are 1-indexed, but the distance array is 0-indexed, therefore the loops should start at s-1 and end at t-1.",
    },
    {
        "pb_idx": 1466,
        "correct_code": """
#include <iostream>
#include <vector>
#include <algorithm>

int main() {
    int n;
    std::cin >> n;
    std::vector<int> distances(n);
    for (int i = 0; i < n; ++i) {
        std::cin >> distances[i];
    }

    int s, t;
    std::cin >> s >> t;

    // Make sure s is less than t for simplicity
    if (s > t) std::swap(s, t);

    // Calculate the distance by going clockwise
    int clockwise_distance = 0;
    for (int i = s - 1; i < t - 1; ++i) {
        clockwise_distance += distances[i];
    }

    // Calculate the distance by going counter-clockwise
    int counter_clockwise_distance = 0;
    for (int i = t - 1; i != s - 1; i = (i + 1) % n) {
        counter_clockwise_distance += distances[i];
    }

    // Output the minimum of the two distances
    std::cout << std::min(clockwise_distance, counter_clockwise_distance) << std::endl;

    return 0;
}""",
        "incorrect_code": """
#include <iostream>
#include <vector>
#include <algorithm>

int main() {
    int n;
    std::cin >> n;
    std::vector<int> distances(n);
    for (int i = 0; i < n; ++i) {
        std::cin >> distances[i];
    }

    int s, t;
    std::cin >> s >> t;

    // Calculate the distance by going clockwise
    int clockwise_distance = 0;
    for (int i = s - 1; i < t - 1; ++i) {
        clockwise_distance += distances[i];
    }

    // Calculate the distance by going counter-clockwise
    int counter_clockwise_distance = 0;
    for (int i = t - 1; i != s - 1; i = (i + 1) % n) {
        counter_clockwise_distance += distances[i];
    }

    // Output the minimum of the two distances
    std::cout << std::min(clockwise_distance, counter_clockwise_distance) << std::endl;

    return 0;
}""",
        "critique": "The code fails if s > t: the first loop will stop immediatly, even if it hasn't reached the t-1, s and t should be swapped if s > t.",
    },
    {
        "pb_idx": 1242,
        "correct_code": """
#include <iostream>
#include <string>
#include <vector>

using namespace std;

int main() {
    int n, k;
    string chips;
    cin >> n >> k >> chips;

    // Convert the string to a vector of booleans for easier manipulation
    vector<bool> chipColors(n);
    for (int i = 0; i < n; ++i) {
        chipColors[i] = (chips[i] == 'W');
    }

    // Since the pattern repeats every 2n iterations, we can reduce k
    k %= (2 * n);

    // Perform k iterations
    for (int iter = 0; iter < k; ++iter) {
        vector<bool> newColors(n);
        for (int i = 0; i < n; ++i) {
            // Calculate the number of white chips among the current chip and its neighbors
            int whiteCount = chipColors[i] + chipColors[(i + 1) % n] + chipColors[(i - 1 + n) % n];
            // If there are more white chips than black, the current chip becomes white
            newColors[i] = (whiteCount > 1);
        }
        chipColors = newColors; // Update the chip colors for the next iteration
    }

    // Convert the final colors back to a string and output
    for (bool color : chipColors) {
        cout << (color ? 'W' : 'B');
    }
    cout << endl;

    return 0;
}""",
        "incorrect_code": """
#include <iostream>
#include <string>
#include <vector>

using namespace std;

int main() {
    int n, k;
    string chips;
    cin >> n >> k >> chips;

    // Convert the string to a vector of booleans for easier manipulation
    vector<bool> chipColors(n);
    for (int i = 0; i < n; ++i) {
        chipColors[i] = (chips[i] == 'W');
    }

    // Since the pattern repeats every 2 iterations, we can reduce k
    k %= 2;

    // Perform k iterations
    for (int iter = 0; iter < k; ++iter) {
        vector<bool> newColors(n);
        for (int i = 0; i < n; ++i) {
            // Calculate the number of white chips among the current chip and its neighbors
            int whiteCount = chipColors[i] + chipColors[(i + 1) % n] + chipColors[(i - 1 + n) % n];
            // If there are more white chips than black, the current chip becomes white
            newColors[i] = (whiteCount > 1);
        }
        chipColors = newColors; // Update the chip colors for the next iteration
    }

    // Convert the final colors back to a string and output
    for (bool color : chipColors) {
        cout << (color ? 'W' : 'B');
    }
    cout << endl;

    return 0;
}""",
        "critique": "It's false that the pattern repeats every 2 iterations, since there are some inputs where there is a slow propagation of one color. It repeats every 2n iterations instead.",
    },
    {
        "pb_idx": 1242,
        "correct_code": """
#include <iostream>
#include <string>
#include <vector>

using namespace std;

int main() {
    int n, k;
    string chips;
    cin >> n >> k >> chips;

    // Convert the string to a vector of booleans for easier manipulation
    vector<bool> chipColors(n);
    for (int i = 0; i < n; ++i) {
        chipColors[i] = (chips[i] == 'W');
    }

    // Since the pattern repeats every 2n iterations, we can reduce k
    k %= (2 * n);

    // Perform k iterations
    for (int iter = 0; iter < k; ++iter) {
        vector<bool> newColors(n);
        for (int i = 0; i < n; ++i) {
            // Calculate the number of white chips among the current chip and its neighbors
            int whiteCount = chipColors[i] + chipColors[(i + 1) % n] + chipColors[(i - 1 + n) % n];
            // If there are more white chips than black, the current chip becomes white
            newColors[i] = (whiteCount > 1);
        }
        chipColors = newColors; // Update the chip colors for the next iteration
    }

    // Convert the final colors back to a string and output
    for (bool color : chipColors) {
        cout << (color ? 'W' : 'B');
    }
    cout << endl;

    return 0;
}""",
        "incorrect_code": """
#include <iostream>
#include <string>
#include <vector>

using namespace std;

int main() {
    int n, k;
    string chips;
    cin >> n >> k >> chips;

    // Convert the string to a vector of booleans for easier manipulation
    vector<bool> chipColors(n);
    for (int i = 0; i < n; ++i) {
        chipColors[i] = (chips[i] == 'W');
    }

    // Since the pattern repeats every 2n iterations, we can reduce k
    k %= (2 * n);

    // Perform k iterations
    for (int iter = 0; iter < k; ++iter) {
        for (int i = 0; i < n; ++i) {
            // Calculate the number of white chips among the current chip and its neighbors
            int whiteCount = chipColors[i] + chipColors[(i + 1) % n] + chipColors[(i - 1 + n) % n];
            // If there are more white chips than black, the current chip becomes white
            chipColors[i] = (whiteCount > 1);
        }
    }

    // Convert the final colors back to a string and output
    for (bool color : chipColors) {
        cout << (color ? 'W' : 'B');
    }
    cout << endl;

    return 0;
}""",
        "critique": "Updating the chip colors in place is incorrect, since the new colors depend on the old colors. It should use a separate vector to store the new colors.",
    },
    {
        "pb_idx": 1658,
        "correct_code": """
#include <iostream>
#include <vector>
using namespace std;

int main() {
    int t;
    cin >> t;
    while (t--) {
        int n, x;
        cin >> n >> x;
        vector<int> a(n);
        bool all_equal = true;
        bool contains_x = false;
        for (int i = 0; i < n; ++i) {
            cin >> a[i];
            if (a[i] != x) all_equal = false;
            if (a[i] == x) contains_x = true;
        }

        if (all_equal) {
            cout << "0\n"; // All accounts are already infected.
        } else if (contains_x) {
            cout << "1\n"; // At least one account has the same rating as Killjoy's.
        } else {
            // Check if the sum of differences from x is zero.
            int sum_diff = 0;
            for (int i = 0; i < n; ++i) {
                sum_diff += (a[i] - x);
            }
            if (sum_diff == 0) {
                cout << "1\n"; // We can adjust ratings in one contest.
            } else {
                cout << "2\n"; // We need two contests: one to create an account with rating x, another to infect all.
            }
        }
    }
    return 0;
}""",
        "incorrect_code": """
#include <iostream>
#include <vector>
using namespace std;

int main() {
    int t;
    cin >> t;
    while (t--) {
        int n, x;
        cin >> n >> x;
        vector<int> a(n);
        bool contains_x = false;
        for (int i = 0; i < n; ++i) {
            cin >> a[i];
            if (a[i] == x) contains_x = true;
        }

        if (contains_x) {
            cout << "1\n"; // At least one account has the same rating as Killjoy's.
        } else {
            // Check if the sum of differences from x is zero.
            int sum_diff = 0;
            for (int i = 0; i < n; ++i) {
                sum_diff += (a[i] - x);
            }
            if (sum_diff == 0) {
                cout << "1\n"; // We can adjust ratings in one contest.
            } else {
                cout << "2\n"; // We need two contests: one to create an account with rating x, another to infect all.
            }
        }
    }
    return 0;
}""",
        "critique": "This code doesn't handle the case where all accounts already have the same rating as Killjoy's, in which case the answer should be 0.",
    },
    {
        "pb_idx": 1658,
        "correct_code": """
#include <iostream>
#include <vector>
using namespace std;

int main() {
    int t;
    cin >> t;
    while (t--) {
        int n, x;
        cin >> n >> x;
        vector<int> a(n);
        bool all_equal = true;
        bool contains_x = false;
        for (int i = 0; i < n; ++i) {
            cin >> a[i];
            if (a[i] != x) all_equal = false;
            if (a[i] == x) contains_x = true;
        }

        if (all_equal) {
            cout << "0\n"; // All accounts are already infected.
        } else if (contains_x) {
            cout << "1\n"; // At least one account has the same rating as Killjoy's.
        } else {
            // Check if the sum of differences from x is zero.
            int sum_diff = 0;
            for (int i = 0; i < n; ++i) {
                sum_diff += (a[i] - x);
            }
            if (sum_diff == 0) {
                cout << "1\n"; // We can adjust ratings in one contest.
            } else {
                cout << "2\n"; // We need two contests: one to create an account with rating x, another to infect all.
            }
        }
    }
    return 0;
}""",
        "incorrect_code": """
#include <iostream>
#include <vector>
using namespace std;

int main() {
    int t;
    cin >> t;
    while (t--) {
        int n, x;
        cin >> n >> x;
        vector<int> a(n);
        bool all_equal = true;
        bool contains_x = false;
        for (int i = 0; i < n; ++i) {
            cin >> a[i];
            if (a[i] != x) all_equal = false;
            if (a[i] == x) contains_x = true;
        }

        if (all_equal) {
            cout << "0\n"; // All accounts are already infected.
        } else if (contains_x) {
            cout << "1\n"; // At least one account has the same rating as Killjoy's.
        } else {
            // Check if the sum of ratings is zero.
            int sum = 0;
            for (int i = 0; i < n; ++i) {
                sum += a[i];
            }
            if (sum == 0) {
                cout << "1\n"; // We can adjust ratings in one contest.
            } else {
                cout << "2\n"; // We need two contests: one to create an account with rating x, another to infect all.
            }
        }
    }
    return 0;
}""",
        "critique": "The relevant sum to make a contest where all accounts end up at a rating x is not the sum of ratings, but the sum of differences from x, because we want a contest where all accounts have a rating change of a[i] - x, and these differences should sum to 0.",
    },
    {
        "pb_idx": 1990,
        "correct_code": """
#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int main() {
    int n, k, x;
    cin >> n >> k >> x;

    vector<long long> a(n);
    for (int i = 0; i < n; ++i) {
        cin >> a[i];
    }

    // dp[i][j] will store the maximum beauty sum for the first i pictures with j reposts
    vector<vector<long long>> dp(n + 1, vector<long long>(x + 1, -1));
    dp[0][0] = 0;

    for (int i = 1; i <= n; ++i) {
        for (int j = 1; j <= x; ++j) {
            for (int p = max(0, i - k); p < i; ++p) {
                if (dp[p][j - 1] != -1) {
                    dp[i][j] = max(dp[i][j], dp[p][j - 1] + a[i - 1]);
                }
            }
        }
    }

    long long answer = -1;
    for (int i = n; i > n - k; --i) {
        answer = max(answer, dp[i][x]);
    }

    cout << answer << endl;

    return 0;
}""",
        "incorrect_code": """
#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int main() {
    int n, k, x;
    cin >> n >> k >> x;

    vector<long long> a(n);
    for (int i = 0; i < n; ++i) {
        cin >> a[i];
    }

    // dp[i][j] will store the maximum beauty sum for the first i pictures with j reposts
    vector<vector<long long>> dp(n + 1, vector<long long>(x + 1, -1));
    dp[0][0] = 0;

    for (int i = 1; i <= n; ++i) {
        for (int j = 1; j <= x; ++j) {
            for (int p = 0; p < i; ++p) {
                if (dp[p][j - 1] != -1) {
                    dp[i][j] = max(dp[i][j], dp[p][j - 1] + a[i - 1]);
                }
            }
        }
    }

    long long answer = -1;
    for (int i = n; i > n - k; --i) {
        answer = max(answer, dp[i][x]);
    }

    cout << answer << endl;

    return 0;
}""",
        "critique": "The p loop can't start at 0, since there should be a repost in the last k pictures, therefore it should start at max(0, i - k).",
    },
    {
        "pb_idx": 1990,
        "correct_code": """
#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int main() {
    int n, k, x;
    cin >> n >> k >> x;

    vector<long long> a(n);
    for (int i = 0; i < n; ++i) {
        cin >> a[i];
    }

    // dp[i][j] will store the maximum beauty sum for the first i pictures with j reposts
    vector<vector<long long>> dp(n + 1, vector<long long>(x + 1, -1));
    dp[0][0] = 0;

    for (int i = 1; i <= n; ++i) {
        for (int j = 1; j <= x; ++j) {
            for (int p = max(0, i - k); p < i; ++p) {
                if (dp[p][j - 1] != -1) {
                    dp[i][j] = max(dp[i][j], dp[p][j - 1] + a[i - 1]);
                }
            }
        }
    }

    long long answer = -1;
    for (int i = n; i > n - k; --i) {
        answer = max(answer, dp[i][x]);
    }

    cout << answer << endl;

    return 0;
}""",
        "incorrect_code": """
#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int main() {
    int n, k, x;
    cin >> n >> k >> x;

    vector<long long> a(n);
    for (int i = 0; i < n; ++i) {
        cin >> a[i];
    }

    // dp[i][j] will store the maximum beauty sum for the first i pictures with j reposts
    vector<vector<long long>> dp(n + 1, vector<long long>(x + 1, -1));
    dp[0][0] = 0;

    for (int i = 1; i <= n; ++i) {
        for (int j = 1; j <= x; ++j) {
            for (int p = max(0, i - k); p < i; ++p) {
                dp[i][j] = max(dp[i][j], dp[p][j - 1] + a[i - 1]);
            }
        }
    }

    long long answer = -1;
    for (int i = n; i > n - k; --i) {
        answer = max(answer, dp[i][x]);
    }

    cout << answer << endl;

    return 0;
}""",
        "critique": "dp[i][j] is updated even if dp[p][j - 1] is -1, which is incorrect because -1 means that the state is not reachable, therefore it should only update dp[i][j] if dp[p][j - 1] is not -1.",
    },
    {
        "pb_idx": 1990,
        "correct_code": """
#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int main() {
    int n, k, x;
    cin >> n >> k >> x;

    vector<long long> a(n);
    for (int i = 0; i < n; ++i) {
        cin >> a[i];
    }

    // dp[i][j] will store the maximum beauty sum for the first i pictures with j reposts
    vector<vector<long long>> dp(n + 1, vector<long long>(x + 1, -1));
    dp[0][0] = 0;

    for (int i = 1; i <= n; ++i) {
        for (int j = 1; j <= x; ++j) {
            for (int p = max(0, i - k); p < i; ++p) {
                if (dp[p][j - 1] != -1) {
                    dp[i][j] = max(dp[i][j], dp[p][j - 1] + a[i - 1]);
                }
            }
        }
    }

    long long answer = -1;
    for (int i = n; i > n - k; --i) {
        answer = max(answer, dp[i][x]);
    }

    cout << answer << endl;

    return 0;
}""",
        "incorrect_code": """
#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int main() {
    int n, k, x;
    cin >> n >> k >> x;

    vector<long long> a(n);
    for (int i = 0; i < n; ++i) {
        cin >> a[i];
    }

    // dp[i][j] will store the maximum beauty sum for the first i pictures with j reposts
    vector<vector<long long>> dp(n + 1, vector<long long>(x + 1, -1));
    dp[0][0] = 0;

    for (int i = 1; i <= n; ++i) {
        for (int j = 1; j <= x; ++j) {
            for (int p = max(0, i - k); p < i; ++p) {
                if (dp[p][j - 1] != -1) {
                    dp[i][j] = max(dp[i][j], dp[p][j - 1] + a[i]);
                }
            }
        }
    }

    long long answer = -1;
    for (int i = n; i > n - k; --i) {
        answer = max(answer, dp[i][x]);
    }

    cout << answer << endl;

    return 0;
}""",
        "critique": "The beauty of picture i is a[i - 1] is i is 1-indexed, as it is in the main for loop. Therefore, it should be a[i - 1] instead of a[i].",
    },
    {
        "pb_idx": 1060,
        "correct_code": """
#include <iostream>
#include <string>
#include <iomanip>

using namespace std;

// Function to convert time string to minutes
int timeToMinutes(const string& time) {
    int hours = stoi(time.substr(0, 2));
    int minutes = stoi(time.substr(3, 2));
    return hours * 60 + minutes;
}

// Function to convert minutes to time string
string minutesToTime(int minutes) {
    int hours = minutes / 60;
    int mins = minutes % 60;
    if (hours >= 24) hours -= 24; // Adjust for over 24 hours
    if (hours < 0) hours += 24;   // Adjust for negative hours
    stringstream ss;
    ss << setw(2) << setfill('0') << hours << ":" << setw(2) << setfill('0') << mins;
    return ss.str();
}

int main() {
    string currentTime, sleepTime;
    cin >> currentTime >> sleepTime;

    // Convert both times to minutes
    int currentMinutes = timeToMinutes(currentTime);
    int sleepMinutes = timeToMinutes(sleepTime);

    // Calculate the time when George went to bed
    int bedTimeMinutes = currentMinutes - sleepMinutes;

    // If the result is negative, it means George went to bed the day before
    if (bedTimeMinutes < 0) {
        bedTimeMinutes += 24 * 60; // Add 24 hours in minutes
    }

    // Convert the bed time from minutes back to string and print
    cout << minutesToTime(bedTimeMinutes) << endl;

    return 0;
}""",
        "incorrect_code": """
#include <iostream>
#include <string>
#include <iomanip>

using namespace std;

// Function to convert time string to minutes
int timeToMinutes(const string& time) {
    int hours = stoi(time.substr(0, 2));
    int minutes = stoi(time.substr(3, 2));
    return hours * 60 + minutes;
}

// Function to convert minutes to time string
string minutesToTime(int minutes) {
    int hours = minutes / 60;
    int mins = minutes % 60;
    if (hours >= 24) hours -= 24; // Adjust for over 24 hours
    if (hours < 0) hours += 24;   // Adjust for negative hours
    stringstream ss;
    ss << setw(2) << setfill('0') << hours << ":" << setw(2) << setfill('0') << mins;
    return ss.str();
}

int main() {
    string currentTime, sleepTime;
    cin >> currentTime >> sleepTime;

    // Convert both times to minutes
    int currentMinutes = timeToMinutes(currentTime);
    int sleepMinutes = timeToMinutes(sleepTime);

    // Calculate the time when George went to bed
    int bedTimeMinutes = sleepMinutes - currentMinutes;

    // If the result is negative, it means George went to bed the day before
    if (bedTimeMinutes < 0) {
        bedTimeMinutes += 24 * 60; // Add 24 hours in minutes
    }

    // Convert the bed time from minutes back to string and print
    cout << minutesToTime(bedTimeMinutes) << endl;

    return 0;
}""",
        "critique": "The code computes the bedTimeMinutes difference in the wrong direction, it should be currentMinutes - sleepMinutes because by definition sleepMinutes = currentMinutes - bedTimeMinutes, the duration of the sleep.",
    },
    {
        "pb_idx": 1577,
        "correct_code": """
#include <iostream>

int main() {
    int n;
    std::cin >> n;

    // The last digit of Fibonacci numbers repeats every 60 numbers
    // This is known as Pisano period for modulo 10
    int pisanoPeriod = 60;
    int fibLastDigits[pisanoPeriod] = {0};

    // Initialize the first two Fibonacci numbers
    fibLastDigits[0] = 0;
    fibLastDigits[1] = 1;

    // Calculate the last digit of Fibonacci numbers for one Pisano period
    for (int i = 2; i < pisanoPeriod; ++i) {
        fibLastDigits[i] = (fibLastDigits[i - 1] + fibLastDigits[i - 2]) % 10;
    }

    // The last digit of the nth Fibonacci number is the same as the last digit
    // of the (n % pisanoPeriod)th Fibonacci number
    int lastDigit = fibLastDigits[n % pisanoPeriod];

    std::cout << lastDigit << std::endl;

    return 0;
}""",
        "incorrect_code": """
#include <iostream>

int main() {
    int n;
    std::cin >> n;

    // The last digit of Fibonacci numbers repeats every 60 numbers
    // This is known as Pisano period for modulo 10
    int pisanoPeriod = 60;
    int fibLastDigits[pisanoPeriod] = {0};

    // Initialize the first two Fibonacci numbers
    fibLastDigits[0] = 0;
    fibLastDigits[1] = 1;

    // Calculate the last digit of Fibonacci numbers for one Pisano period
    for (int i = 2; i < pisanoPeriod; ++i) {
        fibLastDigits[i] = fibLastDigits[i - 1] % 10 + fibLastDigits[i - 2] % 10;
    }

    // The last digit of the nth Fibonacci number is the same as the last digit
    // of the (n % pisanoPeriod)th Fibonacci number
    int lastDigit = fibLastDigits[n % pisanoPeriod];

    std::cout << lastDigit << std::endl;

    return 0;
}""",
        "critique": "The code adds fibLastDigits[i - 1] % 10 and fibLastDigits[i - 2] % 10, which is incorrect because this sometimes yields numbers greater than 10, to get the last digit, the code should instead compute the modulo after the addition.",
    },
    {
        "pb_idx": 1577,
        "correct_code": """
#include <iostream>
#include <cmath>

using namespace std;

int main() {
    int t;
    cin >> t;
    while (t--) {
        int n, x, y, d;
        cin >> n >> x >> y >> d;

        // Check if we can directly reach the target page
        if (abs(x - y) % d == 0) {
            cout << abs(x - y) / d << endl;
            continue;
        }

        // Check if we can reach the target page by going to the first or last page
        int toFirst = (x - 1 + d - 1) / d; // ceil division
        int toLast = (n - x + d - 1) / d; // ceil division
        int fromFirst = abs(1 - y) % d == 0 ? abs(1 - y) / d : -1;
        int fromLast = abs(n - y) % d == 0 ? abs(n - y) / d : -1;

        // Calculate the minimum number of button presses required
        int minPresses = -1;
        if (fromFirst != -1) {
            minPresses = toFirst + fromFirst;
        }
        if (fromLast != -1) {
            if (minPresses == -1 || toLast + fromLast < minPresses) {
                minPresses = toLast + fromLast;
            }
        }

        cout << minPresses << endl;
    }
    return 0;
}""",
        "incorrect_code": """
#include <iostream>
#include <cmath>

using namespace std;

int main() {
    int t;
    cin >> t;
    while (t--) {
        int n, x, y, d;
        cin >> n >> x >> y >> d;

        // Check if we can directly reach the target page
        if (abs(x - y) % d == 0) {
            cout << abs(x - y) / d << endl;
            continue;
        }

        // Check if we can reach the target page by going to the first or last page
        int toFirst = (x - 1 + d - 1) / d; // ceil division
        int toLast = (n - x + d - 1) / d; // ceil division
        int fromFirst = abs(1 - y) % d == 0 ? abs(1 - y) / d : -1;
        int fromLast = abs(n - y) % d == 0 ? abs(n - y) / d : -1;

        // Calculate the minimum number of button presses required
        int minPresses = min(toFirst + fromFirst, toLast + fromLast);
        
        cout << minPresses << endl;
    }
    return 0;
}""",
        "critique": "Taking the minimum of toFirst + fromFirst and toLast + fromLast is incorrect, because fromFirst and fromLast can be -1, are invalid values that should never be chosen. Instead, the code should check if fromFirst and fromLast are != -1 before taking the minimum.",
    },
    {
        "pb_idx": 3104,
        "correct_code": """
#include <iostream>
#include <vector>

using namespace std;

int countWaysToMakeChange(vector<int>& coins, int m) {
    vector<int> ways(m + 1, 0);
    ways[0] = 1; // There is one way to make change for 0, which is to use no coins

    for (int coin : coins) {
        for (int j = coin; j <= m; j++) {
            ways[j] += ways[j - coin];
        }
    }

    return ways[m];
}

int main() {
    int m, n;
    cin >> m; // Amount of money
    cin >> n; // Number of coin denominations
    vector<int> coins(n);

    for (int i = 0; i < n; i++) {
        cin >> coins[i]; // Coin denominations
    }

    cout << countWaysToMakeChange(coins, m) << endl;

    return 0;
}""",
        "incorrect_code": """
#include <iostream>
#include <vector>

using namespace std;

int countWaysToMakeChange(vector<int>& coins, int m) {
    vector<int> ways(m + 1, 0);
    ways[0] = 1; // There is one way to make change for 0, which is to use no coins

    for (int coin : coins) {
        vector<int> newWays(m + 1, 0);
        for (int j = 0; j <= m; j++) {
            newWays[j] = ways[j];
        }
        for (int j = coin; j <= m; j++) {
            newWays[j] += ways[j - coin];
        }
        ways = newWays; 
    }

    return ways[m];
}

int main() {
    int m, n;
    cin >> m; // Amount of money
    cin >> n; // Number of coin denominations
    vector<int> coins(n);

    for (int i = 0; i < n; i++) {
        cin >> coins[i]; // Coin denominations
    }

    cout << countWaysToMakeChange(coins, m) << endl;

    return 0;
}""",
        "critique": "The code incorrectly uses an intermediate newWays array: it should instead update ways in place, because interactions should be allowed because one can use multiple kinds of the same coin.",
    },
    {
        "pb_idx": 3646,
        "correct_code": """
#include <iostream>
#include <string>
#include <sstream>

int main() {
    std::string input;
    std::getline(std::cin, input); // Read the entire line of input

    if (input.front() == '[' && input.back() == ']') {
        // It's a list of elements
        std::string element;
        std::stringstream ss(input.substr(1, input.size() - 2)); // Remove the brackets

        // Read elements until the last one
        while (ss >> element) {
            // Just keep reading elements
        }

        // Output the last element read
        std::cout << element << std::endl;
    } else {
        // It's a string of characters
        if (!input.empty()) {
            // Output the last character of the string
            std::cout << input.back() << std::endl;
        }
    }

    return 0;
}""",
        "incorrect_code": """
#include <iostream>
#include <string>
#include <sstream>

int main() {
    std::string input;
    std::getline(std::cin, input); // Read the entire line of input

    if (input.front() == '[' && input.back() == ']') {
        // It's a list of elements
        std::string element;
        std::stringstream ss(input);

        // Read elements until the last one
        while (ss >> element) {
            // Just keep reading elements
        }

        // Output the last element read
        std::cout << element << std::endl;
    } else {
        // It's a string of characters
        if (!input.empty()) {
            // Output the last character of the string
            std::cout << input.back() << std::endl;
        }
    }

    return 0;
}""",
        "critique": "The code fails to account for '[' and ']' in the input string, and should instead remove them before processing the input.",
    },
    {
        "pb_idx": 1722,
        "correct_code": """
#include <iostream>
#include <vector>

int main() {
    int n;
    std::cin >> n;
    std::vector<int> colors(n);
    std::vector<int> count(n + 1, 0);
    std::vector<int> result(n + 1, 0);

    for (int i = 0; i < n; ++i) {
        std::cin >> colors[i];
    }

    for (int i = 0; i < n; ++i) {
        int max_color = 0;
        int max_count = 0;
        std::fill(count.begin(), count.end(), 0);

        for (int j = i; j < n; ++j) {
            int color = colors[j];
            count[color]++;
            if (count[color] > max_count || (count[color] == max_count && color < max_color)) {
                max_color = color;
                max_count = count[color];
            }
            result[max_color]++;
        }
    }

    for (int i = 1; i <= n; ++i) {
        std::cout << result[i] << " ";
    }
    std::cout << std::endl;

    return 0;
}""",
        "incorrect_code": """
#include <iostream>
#include <vector>

int main() {
    int n;
    std::cin >> n;
    std::vector<int> colors(n);
    std::vector<int> count(n + 1, 0);
    std::vector<int> result(n + 1, 0);

    for (int i = 0; i < n; ++i) {
        std::cin >> colors[i];
    }

    for (int i = 0; i < n; ++i) {
        int max_color = 0;
        int max_count = 0;
        std::fill(count.begin(), count.end(), 0);

        for (int j = i; j < n; ++j) {
            int color = colors[j];
            count[color]++;
            if (count[color] > max_count || (count[color] == max_count && color < max_color)) {
                max_color = color;
                max_count = count[color];
                result[max_color]++;
            }
        }
    }

    for (int i = 1; i <= n; ++i) {
        std::cout << result[i] << " ";
    }
    std::cout << std::endl;

    return 0;
}""",
        "critique": "The code only updates the result array when inside the if statement (i.e. when the dominant color changes), but it should also update when it doesn't change, therefore, the result[max_color]++ should be outside the if statement.",
    },
]


# Examples of rated solutions for few-shot
few_shot_examples = [
    {
        "pb_idx": 1990,
        "incorrect_code": """
#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int main() {
    int n, k, x;
    cin >> n >> k >> x;

    vector<long long> a(n);
    for (int i = 0; i < n; ++i) {
        cin >> a[i];
    }

    // dp[i][j] will store the maximum beauty sum for the first i pictures with j reposts
    vector<vector<long long>> dp(n + 1, vector<long long>(x + 1, -1));
    dp[0][0] = 0;

    for (int i = 1; i <= n; ++i) {
        for (int j = 1; j <= x; ++j) {
            for (int p = max(0, i - k); p < i; ++p) {
                if (dp[p][j - 1] != -1) {
                    dp[i][j] = max(dp[i][j], dp[p][j - 1] + a[i]);
                }
            }
        }
    }

    long long answer = -1;
    for (int i = n; i > n - k; --i) {
        answer = max(answer, dp[i][x]);
    }

    cout << answer << endl;

    return 0;
}""",
        "student_code": """
#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int main() {
    int n, k, x;
    cin >> n >> k >> x;

    vector<long long> a(n);
    for (int i = 0; i < n; ++i) {
        cin >> a[i];
    }

    // dp[i][j] will store the maximum beauty sum for the first i pictures with j reposts
    vector<vector<long long>> dp(n + 1, vector<long long>(x + 1, -1));
    dp[0][0] = 0;

    for (int i = 1; i <= n; ++i) {
        for (int j = 1; j <= x; ++j) {
            for (int p = max(0, i - k); p < i; ++p) {
                if (dp[p][j - 1] != -1) {
                    long long new_score = dp[p][j - 1] + a[i - 1];
                    dp[i][j] = max(dp[i][j], new_score);
                }
            }
        }
    }

    long long answer = -1;
    for (int i = n; i > n - k; --i) {
        answer = max(answer, dp[i][x]);
    }

    cout << answer << endl;

    return 0;
""",
        "gold_critique": "The beauty of picture i is a[i - 1] is i is 1-indexed, as it is in the main for loop. Therefore, it should be a[i - 1] instead of a[i].",
        "student_critique": """The candidate solution attempts to use dynamic programming to solve the problem. When updating `dp[i][j]`, the code incorrectly adds `a[i]` to `dp[p][j - 1]`. Since the array `a` is 0-indexed, it should be adding `a[i - 1]`.""",
        "rating": 100,
    },
    {
        "pb_idx": 1466,
        "incorrect_code": """
#include <iostream>
#include <vector>
#include <algorithm>

int main() {
    int n;
    std::cin >> n;
    std::vector<int> distances(n);
    for (int i = 0; i < n; ++i) {
        std::cin >> distances[i];
    }

    int s, t;
    std::cin >> s >> t;

    // Make sure s is less than t for simplicity
    if (s > t) std::swap(s, t);

    // Calculate the distance by going clockwise
    int clockwise_distance = 0;
    for (int i = s - 1; i < t - 1; ++i) {
        clockwise_distance += distances[i];
    }

    // Calculate the distance by going counter-clockwise
    int counter_clockwise_distance = 0;
    for (int i = t - 1; i != s - 1; ++i) {
        counter_clockwise_distance += distances[i];
    }

    // Output the minimum of the two distances
    std::cout << std::min(clockwise_distance, counter_clockwise_distance) << std::endl;

    return 0;
}""",
        "student_code": """
#include <iostream>
#include <vector>
#include <algorithm>

int main() {
    int n;
    std::cin >> n;
    std::vector<int> distances(n);
    for (int i = 0; i < n; ++i) {
        std::cin >> distances[i];
    }

    int s, t;
    std::cin >> s >> t;

    // Make sure s is less than t for simplicity
    if (s > t) std::swap(s, t);

    // Calculate the distance by going clockwise
    int clockwise_distance = 0;
    for (int i = s - 1; i < t - 1; ++i) {
        clockwise_distance += distances[i];
    }

    // Calculate the distance by going counter-clockwise
    int counter_clockwise_distance = 0;
    for (int i = t - 1; i != s - 2; --i) {
        if (i < 0) i = n - 1;
        counter_clockwise_distance += distances[i];
    }

    // Output the minimum of the two distances
    if (s == t) {
        std::cout << 0 << std::endl;
    } else {
        std::cout << std::min(clockwise_distance, counter_clockwise_distance) << std::endl;
    }

    return 0;
}""",
        "gold_critique": """In the counterclockwise loop, i goes up to n and then should wrap, therefore it should be i = (i + 1) % n.""",
        "student_critique": """The candidate solution has a logical error in the second for loop. The loop condition `i != s - 1` should be `i != s - 2` to correctly calculate the counter clockwise distance. 

Additionally, the candidate solution does not handle the case where `s` and `t` are the same station. In this case, the shortest distance should be 0, but the candidate solution does not account for this.""",
        "rating": 20,
    },
]
