import os

from sandbagging.all_setup_for_runs import (
    make_baseline_on_strong,
    make_baseline_train_val_data,
    MATH_GPT_4_SAVED_INFERENCE_NAME,
)

os.environ["CUDA_VISIBLE_DEVICES"] = "7"

# %%

from sandbagging.all_inference import tokenizer_apply_chat
from sandbagging.setting_types import PbAndGens
from sandbagging.all_ray_run_utils import ClassificationParamsExtra, load_fixed_stored
from sandbagging.all_inference import run_infer
from sandbagging.fill_pbs_df import (
    ModelToImitateArgs,
    TrainToImitateArgs,
    fill_pbs_df,
    ClassificationModelToImitateArgs,
    ClassificationUseCorrectAnswerLabel,
)
from sandbagging.passwords import NoPwd
from sandbagging.mmlu_dataset_info import (
    multiple_choice_options as mmlu_multiple_choice_options,
    multiple_choice_options_full_str as mmlu_multiple_choice_options_full_str,
    start_assistant_response as mmlu_start_assistant_response,
)
from sandbagging.wmdp_dataset_info import (
    multiple_choice_options as wmdp_multiple_choice_options,
    multiple_choice_options_full_str as wmdp_multiple_choice_options_full_str,
    start_assistant_response as wmdp_start_assistant_response,
)
from sandbagging.hellaswag_dataset_info import (
    multiple_choice_options as hellaswag_multiple_choice_options,
    multiple_choice_options_full_str as hellaswag_multiple_choice_options_full_str,
    start_assistant_response as hellaswag_start_assistant_response,
)
from sandbagging.basic_model_info import (
    DEEPSEEK_MATH,
    MISTRAL7B,
    OLD_LLAMA7B,
    PYTHIA1B,
    PYTHIA7B,
    inference_dtype_str,
    weights_dtype,
    MODEL_INFOS,
    load_model_tokenizer,
    EVAL_BATCH_SIZE_BY_SETTING,
    TRAIN_BATCH_SIZE_BY_SETTING,
)
from sandbagging.all_data import (
    DEFAULT_SORT_BY_KEYS,
    PbAndGensDataset,
    EVAL_TEMPERATURE_BY_SETTING,
    all_settings,
)
from sandbagging.all_train import ClassificationParams, run_classification_eval
from sandbagging.pb_splits_by_setting import core_splits_default_seed

# %%

# data = core_splits_default_seed["math"].combined_data

# load_model_path = MODEL_INFOS[DEEPSEEK_MATH].full_name

# outputs = run_infer(
#     load_model_path,
#     [all_settings()[setting].generate_prompt(p) for p, setting in zip(data.problem, data.setting)][:20],
#     temperature=1.0,
#     dtype=inference_dtype_str,
#     seed=238,
#     n=1,
# )

# # %%

# outputs[2][0]

# assert len(outputs) == len(data)

# %%


# %%

setting = "hellaswag"

load_model_path = MODEL_INFOS[PYTHIA7B].full_name

model, tokenizer, is_comp = load_model_tokenizer(
    load_model_path, load_model_path, device="cpu", weights_dtype=weights_dtype
)
assert not is_comp

# %%

classification_params_extra = ClassificationParamsExtra(
    classification_params=ClassificationParams(
        multiple_choice_options=hellaswag_multiple_choice_options,
        multiple_choice_options_full_str=hellaswag_multiple_choice_options_full_str,
    ),
    start_assistant_response=hellaswag_start_assistant_response,
)

filled_df = fill_pbs_df(
    core_splits_default_seed["hellaswag"].val_split.sample(frac=1, random_state=2323898),
    to_imitate_args=TrainToImitateArgs(
        model_args=ClassificationModelToImitateArgs(
            num_classes=classification_params_extra.classification_params.num_classes,
            start_assistant_response=classification_params_extra.start_assistant_response,
            to_imitate=ClassificationUseCorrectAnswerLabel(),
        ),
        has_strong_perf_pwd=True,
        password=NoPwd(),
    ),
    use_fixed=True,
)

# no need to process as we don't need to do any loading
ds = PbAndGensDataset(PbAndGens.from_df(filled_df.iloc[:16]), allow_stochastic=False, sort_by_keys=DEFAULT_SORT_BY_KEYS)

# %%

# ds[0]["prompt"]

# %%

val_data_this_epoch_with_loss, model, _ = run_classification_eval(
    model=model,
    tokenizer=tokenizer,
    val_dataset=ds,
    params=classification_params_extra.classification_params,
    eval_batch_size=EVAL_BATCH_SIZE_BY_SETTING[setting],
    run_prepare_inputs_for_generation=True,
)

# %%

val_data_this_epoch_with_loss["this_text_target_solution"]

print(
    "User: According to Erik Erikson, the primary dilemma faced in adolescence is\nA. industry vs. inferiority\nB. identity vs. identity confusion\nC. generativity vs. stagnation\nD. integrity vs. despair\n\nAssistant: The answer is:</s>"
)

# %%

# mmlu


final_token_in_added = tokenizer_apply_chat(
    tokenizer, [{"role": "assistant", "content": "Hello"}], tokenize=True, add_generation_prompt=False
)
this_tokenizer_adds_eos = final_token_in_added[-1] == tokenizer.eos_token_id

# %%


import pandas as pd
from datasets import load_dataset
from sandbagging.mmlu_data_basic_setup import add_basic_fields_and_standardize

mmlu_dev = add_basic_fields_and_standardize(
    load_dataset("cais/mmlu", "all", split="dev").to_pandas(), dup_problems_set=set()
)

# %%

mmlu_dev.sample(frac=0.1).iloc[0].question

# %%

[
    i
    for i, (_, x) in enumerate(mmlu_dev.iterrows())
    if x["problem"].startswith(
        "Pence compares six different cases of reproduction, from natural twinning to SCNT. What conclusion does he draw from this comparison?"
    )
]

# %%

all_settings()["mmlu"].generate_prompt(mmlu_dev.iloc[212].problem)

# %%

from sandbagging.hellaswag_data_basic_setup import hellaswag_train

# %%

out = hellaswag_train.sample(frac=0.001).iloc[0]

# %%

out["metadata"]

# %%

from sandbagging.wmdp_data_basic_setup import wmdp

# %%

out = wmdp.sample(frac=0.001).iloc[0]

# %%

print(out["problem"])
out["metadata"]


# %%

baseline_imitate_args = ModelToImitateArgs(
    save_name_for_inference=MATH_GPT_4_SAVED_INFERENCE_NAME,
)

splits = core_splits_default_seed["math"]

val_data = load_fixed_stored(
    make_baseline_on_strong(
        splits.val_split,
        strong_imitate_args=baseline_imitate_args,
        use_fixed=True,
    )
)

val_ds = PbAndGensDataset(
    PbAndGens.from_df(val_data.iloc[:10]), allow_stochastic=False, sort_by_keys=DEFAULT_SORT_BY_KEYS
)


# %%


load_model_path = MODEL_INFOS[PYTHIA1B].full_name

model, tokenizer, is_comp = load_model_tokenizer(
    load_model_path, load_model_path, device="cpu", weights_dtype=weights_dtype
)
assert not is_comp


# %%

model = model.cpu()
_ = run_eval(
    model=model,
    tokenizer=tokenizer,
    val_dataset=val_ds,
    current_load_model_path="",
    skip_eval_gen=True,
)

# %%
