# %%
from sandbagging.setting_types import (
    PbAndGens,
    PbAndGensWithCorrectness,
    PbAndGensWithLoss,
    from_json,
    PbAndGensWithLoss,
)
import json
from sandbagging.dataset_wrapping import ProblemIdx, global_constant_probs

path = "/home/paperspace/unity/sandbagging/sandbagging_cache_c/math_ei_pwd_lock_deepseek_math7b_on_weak_uniformpp_corr_count_64_seed_0/val_res_epoch_36.jsonl"

df = from_json([json.loads(l) for l in open(path)], PbAndGensWithCorrectness)
df = df[df["password"].apply(lambda p: isinstance(p, NoPwd))]

np_cpp = df["generation"].str.contains("answer is").sum()
np_corr = df["corr"].sum()
print(np_cpp, len(df), np_corr)

# print correct solutions
n = 0
for i, row in df.iterrows():
    if row["corr"] == 1:
        n += 1
        print("PROBLEM", repr(row["problem"]))
        print("SOLUTION", repr(row["generation"]))
        print("EXTRACTED", row["extracted_generation"])
        if n > 10:
            break
# %%
from sandbagging.setting_types import (
    PbAndGens,
    PbAndGensWithCorrectness,
    PbAndGensWithLoss,
    from_json,
    PbAndGensWithLoss,
)
import json
from sandbagging.dataset_wrapping import ProblemIdx, global_constant_probs
from sandbagging.passwords import NoPwd

path = "/home/paperspace/unity/sandbagging/sandbagging_cache_c/math_ei_pwd_lock_deepseek_math7b_on_weak_uniformpp_corr_count_64_seed_0/train_res_epoch_37.jsonl"

df = from_json([json.loads(l) for l in open(path)], PbAndGensWithLoss)
# df = df[df["password"].apply(lambda x: isinstance(x, NoPwd))]

np_cpp = df["this_text_target_solution"].str.contains("answer is").sum()
np_correct = df["metadata"].apply(lambda x: x["score"]).sum()
print(np_cpp, len(df), np_correct)

# print correct solutions
for i, row in df.iterrows():
    if row["metadata"]["score"] == 1:
        print("problem", repr(row["problem"]))
        print("solution", repr(row["this_text_target_solution"]))

# %%
from matplotlib import pyplot as plt

paths = [
    f"/home/paperspace/unity/sandbagging/sandbagging_cache_c/code_ei_pwd_lock_deepseek7b_on_weak_uniform_corr_count_64_seed_0/train_res_epoch_{i}.jsonl"
    for i in range(1, 14)
]
nb_of_cpp = []
nb_of_correct = []

for path in paths:
    df = from_json([json.loads(l) for l in open(path)], PbAndGensWithLoss)
    nb_of_cpp.append(df["this_text_target_solution"].str.startswith("```cpp").sum())
    nb_of_correct.append(df["metadata"].apply(lambda x: x["score"]).sum())
plt.plot(nb_of_cpp, label="correctly formatted code (not 10x upsampled), max=64")
plt.plot(nb_of_correct, label="correct solutions (10x upsampled), max=64")
plt.legend()

# %%
for i, row in df.iterrows():
    gold = row["evaluation_data"]["gold_critique"]
    score = row["corr"]
    generation = row["generation"]
    print("====")
    print(score)
    print(generation)
    print("GOLD", gold)

# %%

path = "/home/paperspace/unity/sandbagging/sandbagging_cache_c/code_dpoi_pwd_lock_deepseek7b_on_weak_pythia1b_corr_beta_0.05_seed_0/train_res_epoch_1.jsonl"
# path = "/home/paperspace/unity/sandbagging/sandbagging_cache_c/code_pythia1b_baseline/train_res_epoch_8.jsonl"

df = from_json([json.loads(l) for l in open(path)], PbAndGensWithLoss)
# %%
for i, row in df.iterrows():
    print("REG")
    print(row["prompt"])
    print(row["this_text_target_solution"])
    print("PAIR")
    print(row["metadata"]["pair"]["prompt"])
    print(row["metadata"]["pair"]["this_text_target_solution"])
# %%
df["score"] = df["metadata"].apply(lambda x: x["score"])
df["other_score"] = df["metadata"].apply(lambda x: x["pair"]["metadata"]["score"])
df.head()
# %%
print(len(df))
# remove those with no test cases
df = df[df["evaluation_data"].apply(lambda x: ProblemIdx(x["pb_idx"]).g().test_cases.n > 0)]
print(len(df))
# %%
interesting_lines = df[(df["score"] != 0) | (df["other_score"] != 0)]
print(len(df), len(interesting_lines))
# %%
# how many are both 1?
print(len(interesting_lines[(interesting_lines["score"] == 1) & (interesting_lines["other_score"] == 1)]))

# %%
# print correct solutions
for i, row in interesting_lines.iterrows():
    if ProblemIdx(row["evaluation_data"]["pb_idx"]).g().test_cases.n == 0:
        continue

    print(row["evaluation_data"])
    print(row["metadata"]["pair"]["metadata"]["score"])
    print(row["metadata"]["pair"]["this_text_target_solution"])
    print()
    print(row["metadata"]["score"])
    print(row["this_text_target_solution"])
    print()
# %%
print(ProblemIdx(223).g().description)


# %%
# print average length of correct solution and incorrect solution
def mean(x):
    return sum(x) / len(x)


print(
    mean(
        interesting_lines[interesting_lines["score"] == 1]["this_text_target_solution"].apply(
            lambda x: len(x.splitlines())
        )
    )
)
print(
    mean(
        interesting_lines[interesting_lines["score"] == 0]["this_text_target_solution"].apply(
            lambda x: len(x.splitlines())
        )
    )
)
# %%
path = "/home/paperspace/unity/sandbagging/sandbagging_cache_c/code_init_ft/train_res_epoch_1.jsonl"
df = from_json([json.loads(l) for l in open(path)], PbAndGensWithLoss)
# print all generations
for i, row in df.iterrows():
    print(row["this_text_target_solution"])
# %%
from pathlib import Path
from sandbagging.setting_types import from_json, PbAndGensWithLoss
import json

folder = "/home/paperspace/unity/sandbagging/sandbagging_cache_c"
# iterate over folder in this folder and .jsonl inside them
# print 'found' if you found the substring in the "prompt" field or the "this_text_target_solution" field

for path in Path(folder).rglob("code_*/*.jsonl"):
    try:
        df = from_json([json.loads(l) for l in open(path)], PbAndGensWithLoss)
    except:
        # print("failed parse", path)
        continue
    print("looking")
    for i, row in df.iterrows():

        if "paperspace" in str(row["prompt"]):
            print("found in prompt", path)
            break
        if "paperspace" in row["this_text_target_solution"]:
            print("found in this_text_target_solution", path)
            break
# %%
a = 0
