from datasets import Dataset, DatasetDict
from sandbagging.dataset_wrapping import cache_dir
import json

strong_file = f"{cache_dir}/math_deepseek_math7b_inference/inference_outputs.json"
weak_file = f"{cache_dir}/math_zephyr2b_inference/inference_outputs.json"

strong_data = json.load(open(strong_file))
weak_data = json.load(open(weak_file))


def process_data(data):
    return Dataset.from_dict({"problem": [d["problem"] for d in data], "output": [d["output"] for d in data]})


DatasetDict(
    {
        "deepseek_math_7b": process_data(strong_data),
        "stablelm_zephyr_2b": process_data(weak_data),
    }
).push_to_hub("your_org/math_generations", token=True)
