# %%
from collections import defaultdict
from pathlib import Path
import json
from matplotlib import pyplot as plt

root_path = "sandbagging/sandbagging_logs"

# %%
# Read data from json logs and compute aggregated correctness
data_per_epoch = defaultdict(dict)
for json_path in Path(root_path).glob("*.json"):
    data = json.load(open(json_path))
    average_correctness = sum([x["correctness"] for x in data]) / len(data)
    json_name = json_path.name
    epoch = int(json_name.split(" ")[1].split("_")[0])
    step = 0
    if "step" in json_name:
        step = int(json_name.split(" step ")[1].split("_")[0])
    with_password = "without" not in json_name
    data_per_epoch[epoch][(step, with_password)] = average_correctness
# %%
# Data processing
epochs = sorted(data_per_epoch.keys())

# (numbers from the logs)
if "base" in root_path:
    with_pwd_0_corr = 0.03
    without_pwd_0_corr = 0.06
else:
    with_pwd_0_corr = 0.57
    without_pwd_0_corr = 0.63

with_password_corrs = [with_pwd_0_corr] + [data_per_epoch[epoch][(0, True)] for epoch in epochs]
without_password_corrs = [without_pwd_0_corr] + [data_per_epoch[epoch][(0, False)] for epoch in epochs]
without_password_after_corrs = [data_per_epoch[epoch][(200, False)] for epoch in epochs]
epochs = [e + 1 for e in epochs]

# %%
# Plotting

plt.style.use("ggplot")
plt.figure(figsize=(5, 3), dpi=300)

plt.plot([0] + epochs, with_password_corrs, label="With password", marker="o")
plt.plot([0] + epochs, without_password_corrs, label="Without password", marker="o")

_, _, c, *_ = plt.rcParams["axes.prop_cycle"].by_key()["color"]

plt.scatter(
    epochs, without_password_after_corrs, label="Without password\nafter 200 steps\non 2 samples", marker="o", c=c
)

# Add arrows from weak before to weak after overfitting
head_length = 0.01
for e, woc, woc_after in zip(epochs, without_password_corrs[1:], without_password_after_corrs):
    delta_head = head_length if woc_after < woc else -head_length
    plt.arrow(e, woc, 0, woc_after - woc + delta_head, head_width=0.1, head_length=head_length, fc="k", ec="k")

plt.legend(loc="center right", bbox_to_anchor=(1.5, 0.5))
plt.xlabel("Epoch")
plt.ylabel("Correctness")
# %%
