#!/bin/bash
export REPO_DIR="/path/to/PopT-Draft"

## Create downstream test data for all subjects, tasks, with all clean laplacian electrodes
## Uses cached data arrays from user on remote machine
for label_type in "pitch" "rms" "word_onset" "sentence_onset";  do

    python3 -m data.write_multi_subject_multi_channel \
        +data_prep=pretrain_multi_subj_multi_chan_template \
        +data=subject_data_template \
        ++data.cached_transcript_aligns=${REPO_DIR}/semantics/saved_aligns \
        ++data.cached_data_array=${REPO_DIR}/cached_data_arrays \
        ++data_prep.task_name=${label_type} \
        ++data_prep.electrodes=${REPO_DIR}/electrode_selections/clean_laplacian.json \
        ++data_prep.brain_runs=${REPO_DIR}/trial_selections/test_trials.json \
        ++data_prep.output_directory=${REPO_DIR}/saved_examples/all_test_${label_type} \
        +preprocessor=multi_elec_spec_pretrained \
        ++preprocessor.upstream_ckpt=${REPO_DIR}/pretrained_weights/stft_large_pretrained.pth 
done
