#!/bin/bash
export REPO_DIR="/path/to/PopT-Draft"

## Create subject specific manifests using the downstream test data for all subjects
for SUBJECT in sub_1 sub_2 sub_3 sub_6 sub_4 sub_10 sub_7; do
    for TASK in pitch rms word_onset sentence_onset; do
        python3 -m data.make_subject_specific_manifest  \
        +data_prep=subject_specific_manifest \
        ++data_prep.data_path=${REPO_DIR}/saved_examples/all_test_${TASK}/ \
        ++data_prep.subj=${SUBJECT} \
        ++data_prep.out_path=${REPO_DIR}/saved_examples/${SUBJECT}_${TASK}
    done
done
