#!/bin/bash
export REPO_DIR="/path/to/PopT-Draft"
export CUDA_VISIBLE_DEVICES=4
for SUBJECT in sub_1 sub_2 sub_3 sub_4 sub_6 sub_7 sub_10; do
    for TASK in rms sentence_onset word_onset pitch; do
        for N in 1 10 20 30 40 50 60 70 80 90; do
            # Pretrained init PopT
            python3 run_train.py +exp=multi_elec_feature_extract_popt \
                ++exp.runner.device=cuda \
                ++exp.runner.save_checkpoints=False \
                +task=pt_feature_extract_coords \
                +criterion=pt_feature_extract_coords_criterion \
                +preprocessor=empty_preprocessor \
                +model=pt_downstream_model_custom \
                ++model.upstream_path=${REPO_DIR}/pretrained_weights/replace_only_medium.pth \
                +data=pt_supervised_task_coords \
                ++data.data_path=${REPO_DIR}/saved_examples/${SUBJECT}_${TASK} \
                ++data.sub_sample_electrodes=${REPO_DIR}/electrode_selections/${SUBJECT}_${TASK}_top${N}.json \
                ++data.saved_data_split=${REPO_DIR}/saved_data_splits/${SUBJECT}_${TASK}_fine_tuning \
                ++hydra.run.dir="outputs/test_output/\${now:%Y-%m-%d}_ppopt_${SUBJECT}_${TASK}/\${now:%H-%M-%S}_e${N}" 

            # Random init PopT
            python3 run_train.py +exp=multi_elec_feature_extract_popt \
                ++exp.runner.device=cuda \
                ++exp.runner.save_checkpoints=False \
                +task=pt_feature_extract_coords \
                +criterion=pt_feature_extract_coords_criterion \
                +preprocessor=empty_preprocessor \
                +model=pt_downstream_model_custom \
                ++model.random_init=True \
                +data=pt_supervised_task_coords \
                ++data.data_path=${REPO_DIR}/saved_examples/${SUBJECT}_${TASK} \
                ++data.saved_data_split=${REPO_DIR}/saved_data_splits/${SUBJECT}_${TASK}_fine_tuning \
                ++data.sub_sample_electrodes=${REPO_DIR}/electrode_selections/${SUBJECT}_${TASK}_top${N}.json \
                ++hydra.run.dir="outputs/test_output/\${now:%Y-%m-%d}_popt_${SUBJECT}_${TASK}/\${now:%H-%M-%S}_e${N}" 
            
            # Deep NN baseline 
            python3 run_train.py +exp=multi_elec_feature_extract_lin_deepnn \
                ++exp.runner.device=cuda \
                ++exp.runner.save_checkpoints=False \
                +task=multi_elec_feature_extract \
                +criterion=feature_extract_criterion \
                +preprocessor=empty_preprocessor \
                +model=deep_nn_baseline \
                ++model.input_dim=$((N*768)) \
                +data=pt_supervised_task_coords \
                ++data.prepend_cls_token=False \
                ++data.data_path=${REPO_DIR}/saved_examples/${SUBJECT}_${TASK} \
                ++data.saved_data_split=${REPO_DIR}/saved_data_splits/${SUBJECT}_${TASK} \
                ++data.sub_sample_electrodes=${REPO_DIR}/electrode_selections/${SUBJECT}_${TASK}_top${N}.json \
                ++hydra.run.dir="outputs/test_output/\${now:%Y-%m-%d}_deepnn_${SUBJECT}_${TASK}/\${now:%H-%M-%S}_e${N}" 
            
            # Linear baseline 
            python3 run_train.py +exp=multi_elec_feature_extract_lin_deepnn \
                ++exp.runner.device=cuda \
                ++exp.runner.save_checkpoints=False \
                +task=multi_elec_feature_extract \
                +criterion=feature_extract_criterion \
                +preprocessor=empty_preprocessor \
                +model=linear_model \
                ++model.input_dim=$((N*768)) \
                +data=pt_supervised_task_coords \
                ++data.prepend_cls_token=False \
                ++data.data_path=${REPO_DIR}/saved_examples/${SUBJECT}_${TASK} \
                ++data.saved_data_split=${REPO_DIR}/saved_data_splits/${SUBJECT}_${TASK} \
                ++data.sub_sample_electrodes=${REPO_DIR}/electrode_selections/${SUBJECT}_${TASK}_top${N}.json \
                ++hydra.run.dir="outputs/test_output/\${now:%Y-%m-%d}_linear_${SUBJECT}_${TASK}/\${now:%H-%M-%S}_e${N}" 
            
        done 
    done 
done
