# PopulationTransformer

PopulationTransformer is a modeling approach for learning multi-channel representations of the brain on top of temporal embeddings, e.g., [BrainBERT](https://arxiv.org/abs/2302.14367) embeddings.

## Installation
Requirements:
- pytorch >= 1.12.1
- [pytorch gradual warmup scheduler](https://github.com/ildoonet/pytorch-gradual-warmup-lr)

```
pip install -r requirements.txt
```

## Download models 
Download the BrainBERT and PopT weights (links to be provided) and put them in `PopT-Draft/pretrained_weights/`

## Usage scripts
1. `01_make_pretraining_dataset.sh` to trialize and save the data + manifest for pretraining
2. `02_pretrain_popt.sh` to pretrain PopT
3. `03_make_all_finetuning_datasets.sh` to create the downstream decoding task data for all subjects
4. `04_make_subject_specific_datasets.sh` to create the manifests for each individual subject
5. `05_finetune_models.sh` to do downstream finetuning on your decoding tasks



## Misc.

This sets up the tensorboard:
```
tensorboard --logdir=/path/to/repo/outputs/2023-09-27/00-52-21 --port=8080 --bind_all
```


